<?php 

class Report extends MY_Controller
{
    public $module_name;
	function __construct()
    {
        parent::__construct();
    
        $this->module_name = $this->router->fetch_module();
      
        $this->load->model('../extensions/'.$this->module_name.'/models/Report_model');
        $this->load->model('../extensions/'.$this->module_name.'/models/Room_model');
        $this->load->model('../extensions/'.$this->module_name.'/models/Payment_model');
        $this->load->model('../extensions/'.$this->module_name.'/models/Company_model');
        $this->load->model('../extensions/'.$this->module_name.'/models/Charge_model');

        $global_data['menu_on'] = true;
        $global_data['selected_menu'] = 'reports';      
        $global_data['submenu'] = 'reports/reports_submenu.php';
        $global_data['submenu_parent_url'] = base_url()."reports/";
        $global_data['sidebar_menu_url'] = base_url()."reports/market_segment/";
        $global_data['menu_items'] = $this->Menu_model->get_menus(array('parent_id' => 4, 'wp_id' => 1));
        $global_data['selected_submenu'] = 'Market Segment';
        $global_data['sidebar_links'] = $this->Menu_model->get_menus(array('parent_id' => 10, 'wp_id' => 1));

        $this->load->vars($global_data);
        
    }

    
    function show_customer_type_report($start_date = '', $end_date = '')
    {
        if ($start_date == '') {
            $parts      = explode('-', $this->selling_date);
            $year       = $parts[0];
            $month      = $parts[1];
            $start_date = "$year-$month-01";
        }

        if ($end_date == '') {
            $end_date = date('Y-m-d', strtotime($start_date."+1 month"));
        }

        $data['start_date'] = $start_date;
        $data['end_date']   = $end_date;

        $files = get_asstes_files($this->module_assets_files, $this->module_name, $this->controller_name, $this->function_name);

        $data['selected_sidebar_link'] = 'Customer Type';

        $data['main_content'] = '../extensions/'.$this->module_name.'/views/customer_type';
        $this->template->load('bootstrapped_template', null , $data['main_content'], $data);
    }

    function get_customer_type_data_AJAX() 
    {
        $start_date = $this->input->post('dateStart');
        $end_date   = $this->input->post('dateEnd');
        $result = $this->get_customer_type_data($start_date, $end_date);
        if (!empty($result))
            echo json_encode($result);
        else
            echo "false";
    }

    function get_customer_type_data($start_date, $end_date)
    {

        $type_data = [];

        $company_data = $this->Company_model->get_company($this->company_id);
        $include_cancelled_noshow_bookings = (isset($company_data['include_cancelled_noshow_bookings']) && $company_data['include_cancelled_noshow_bookings']) ? true : false;
        $number_of_rooms = $this->Room_model->get_number_of_rooms($this->company_id);
        $booking_count = $this->Report_model->get_customer_type_data($this->company_id,
            $start_date,
            $end_date,
            'customer_type'
        );

        $total_bookings = $total_room_charge = $total_payment = 0;
        foreach ($booking_count as $data) {
            $customer_type_id = $data['type_id'];
            $charge = $room_charge = $payment = 0;

            $get_charges = $this->Charge_model->get_all_charges($start_date, $end_date, $this->selling_date, false, true, $customer_type_id, null, $include_cancelled_noshow_bookings);
            foreach ($get_charges as $dt => $val) {
                $charge += $val;
            }

            $get_room_charges = $this->Charge_model->get_all_charges($start_date, $end_date, $this->selling_date, true, false, $customer_type_id, null, $include_cancelled_noshow_bookings);
            foreach ($get_room_charges as $dt => $val) {
                $room_charge += $val;
            }

            $get_payment = $this->Payment_model->get_all_payments($start_date, $end_date, $customer_type_id);
            foreach ($get_payment as $dt => $val) {
                $payment += $val;
            }

            $type_data[$data['customer_type']] = [
                'booking_count' => $data['value'],
                'charge_total' => $charge,
                'room_charge_total' => $room_charge,
                'payment_total' => $payment
            ];
            $total_bookings += $data['value'];
            $total_room_charge += $room_charge;
            $total_payment += $payment;
        }
        $result = [];
        foreach ($type_data as $td_key => $td_v) {
            $result[$td_key] = Array(
                "booking_count"  => $td_v['booking_count'],
                "revPAR" => $td_v['room_charge_total'] / $number_of_rooms,
                "ADR" => ($td_v['booking_count'] > 0)?($td_v['room_charge_total'] / $td_v['booking_count']):0,
                "room_charge_total"   => $td_v['room_charge_total'],
                "charge_total"   => $td_v['charge_total'],
                "payment_total"  => $td_v['payment_total']
            );
        }
        return $result;
    }

    function download_customer_type_market_seg_csv_export($start_date = NULL, $end_date = NULL, $group_by = null)
    {        
        $this->load->helper('download');
        $arrayData = $this->get_customer_type_data($start_date, $end_date);

        $csv_keys = array(
            'Type',
            'Bookings',
            'RevPAR',
            'ADR',
            'Room Charges (before taxes)',
            'All Charges (including taxes)',
            'All Payments',
            'Balance'
        );
        $bookings[] = $csv_keys;

        foreach($arrayData as $key => $data)
        {
            $booking_row = array();

            $booking_count = ($data['booking_count']) ? $data['booking_count'] : 0;
            $room_charge_total = ($data['room_charge_total']) ? $data['room_charge_total'] : 0;
            if($booking_count && $room_charge_total)
            {
                $ADR = number_format($data['room_charge_total']/$data['booking_count'], 2, ".", ",");;
            }
            elseif(!$booking_count && !$room_charge_total)
            {
                $ADR = 0.00;
            }
            elseif(!$room_charge_total && $booking_count)
            {
                $ADR = 0.00;
            }
            elseif($room_charge_total && !$booking_count)
            {
                $ADR = 'Infinity';
            }

            $booking_row[] = $key;
            $booking_row[] = ($data['booking_count']) ? $data['booking_count'] : '0';
            $booking_row[] = ($data['revPAR']) ? number_format($data['revPAR'], 2, ".", ",") : '0.00';
            $booking_row[] = $ADR;
            $booking_row[] = ($data['room_charge_total']) ? number_format($data['room_charge_total'], 2, ".", ",") : '0.00';
            $booking_row[] = ($data['charge_total']) ? number_format($data['charge_total'], 2, ".", ",") : '0.00';
            $booking_row[] = ($data['payment_total']) ? number_format($data['payment_total'], 2, ".", ",") : '0.00';
            $booking_row[] = number_format($data['charge_total'] - $data['payment_total'], 2, ".", ",");

            $bookings[] = $booking_row;
        }
        
       force_download_csv($bookings, "customer_type.csv");
    }

   

}